<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/*
 * Created on 04. Jan. 2007 by Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 */

/**
 * BodyFragment class file. 
 * 
 * PHP versions 5
 *   
 * LICENSE:
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the GPL. For more information please see
 * <http://opendocumentphp.org>.
 * 
 * $Id: BodyFragment.php 264 2007-08-06 08:29:08Z nmarkgraf $
 * 
 * @category    File Formats
 * @package     OpenDocumentPHP
 * @subpackage  content_body
 * @author      Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright   Copyright in 2006, 2007 by The OpenDocumentPHP Team 
 * @license     http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version     SVN: $Id: BodyFragment.php 264 2007-08-06 08:29:08Z nmarkgraf $
 * @link        http://opendocumentphp.org
 * @since       0.5.0 - 08. Feb. 2007
 */

/**
 *  
 */
require_once 'OpenDocumentPHP/content/body/table/SpreadsheetFragment.php';
require_once 'OpenDocumentPHP/content/body/table/TableFragment.php';
require_once 'OpenDocumentPHP/content/body/text/Heading.php';
require_once 'OpenDocumentPHP/content/body/text/Paragraph.php';
require_once 'OpenDocumentPHP/content/body/text/TextFragment.php';
require_once 'OpenDocumentPHP/util/ODPElement.php';

/**
 * BodyFragment class. 
 *  
 * @category    File Formats
 * @package     OpenDocumentPHP
 * @subpackage  content_body
 * @author      Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright   Copyright in 2006, 2007 by The OpenDocumentPHP Team 
 * @license     http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version     Release: @package_version@
 * @link        http://opendocumentphp.org
 * @since       0.5.0 - 08. Feb. 2007
 */
class BodyFragment extends ODPElement 
{

	/**
	 * @var 		array Array of tables in this document.
	 * @access		private
	 * @since 		0.5.0 - 08. Feb. 2007
	 */
	private $tables;
	
	/**
	 * @var 		DOMElement
	 * @access		private
	 * @since 		0.5.0 - 08. Feb. 2007
	 */
	private $root;

    /**
     * Constructor method.
     * 
     * @since       0.5.0 - 08. Feb. 2007
     */
    function __construct($elem=null) 
    {         
        if (is_null($elem)) {
           parent::__construct('office:body', '', self::OFFICE);
        } else {
           parent::__construct($elem);         
        }
		$this->tables = array ();
	}
	
	/**
	 * Set current OpenDocument to a spreadsheet document.
	 * 
	 * No mime-type fixing is made, just the <b><office:spreadsheet></b> tag is added.
	 * 
	 * @access 		public
	 * @since 		0.5.0 - 08. Feb. 2007
	 */
	function setSpreadsheet() 
	{		
        $this->root = new SpreadsheetFragment();        
        $this->appendChild($this->root);
	}
	
	/**
	 * Set current OpenDocument to a text document.
     *
	 * No mime-type fixing is made, just the <b><office:text></b> tag is added.
	 *  
	 * @access 		public
	 * @since 		0.5.0 - 08. Feb. 2007
	 */
	function setText() 
	{
		$this->root = new TextFragment();
		$this->appendChild($this->root);
	}
	
	/**
	 * Retrieve a new table
	 * 
	 * @todo           This should be a method in the SpreadsheetFragment class!
	 * @access 		   public
	 * @since 		   0.5.0 - 08. Feb. 2007
	 * @deprecated     0.5.2 - 30. Jul. 2007
	 */
	function getNewTableFragment($name) 
	{
        /*
         * Create new table (fragment).
         */
		$newTable = new TableFragment();
		/*
		 * append newTable to document, to make it writaable!
		 */
        $this->root->appendChild($newTable);
		/*
		 * Set the name of the new table
		 */
		$newTable->setName($name);
		/*
		 * Add new table to table list under its name.
		 * 
		 * We might check if it exists and do something here ..
		 */
		$this->tables[$name] = $newTable;
		/*
		 * return freshly made new table
		 */
		return $newTable;
	}
	
	/**
	 * 
	 * @access         public
	 * @deprecated     0.5.2 - 30. Jul. 2007
	 * @since 		   0.5.0 - 08. Feb. 2007
	 */
	function getDocumentFragment() 
	{
		return $this;
	}
	
	/**
	 * 
	 * @access 		   public
	 * @deprecated     0.5.2 - 26. Feb. 2007
	 * @since 		   0.5.0 - 08. Feb. 2007
	 */
	function nextParagraph() 
	{
        if (is_null($this->root)) {
            $this->getTextFragment();
        }
		return $this->root->nextParagraph();
	}
	
	/**
	 * 
	 * @access 		public
	 * @deprecated	0.5.2 - 26. Feb. 2007
	 * @since 		0.5.0 - 08. Feb. 2007
	 */
	function nextHeading($outlineLevel = '1') 
	{
        if (is_null($this->root)) {
            $this->getTextFragment();
        }	
		return $this->root->nextHeading($outlineLevel);
	}

    /**
     * 
     * @access      public
     * @since       0.5.0 - 08. Feb. 2007
     */
	function getTextFragment() 
	{
        if ($this->root == null) {
            $this->root = new TextFragment($this->getElementByTagNameNS(self::OFFICE, 'text'));            
        }
		return $this->root;
	}

	/**
     * 
     * @access      public
     * @since       0.5.3 - 29. Jul. 2007
     */
    function getSpreadsheetFragment() 
    {
        if ($this->root == null) {
            $this->root = new SpreadsheetFragment($this->getElementByTagNameNS(self::OFFICE, 'spreadsheet'));            
        }
        return $this->root;
    }	
}
?>